<?php
if (session_id() == "") session_start(); // Initialize Session data
ob_start(); // Turn on output buffering
?>
<?php include_once "ewcfg12.php" ?>
<?php include_once ((EW_USE_ADODB) ? "adodb5/adodb.inc.php" : "ewmysql12.php") ?>
<?php include_once "phpfn12.php" ?>
<?php include_once "stats_counterloginfo.php" ?>
<?php include_once "usersinfo.php" ?>
<?php include_once "userfn12.php" ?>
<?php

//
// Page class
//

$stats_counterlog_add = NULL; // Initialize page object first

class cstats_counterlog_add extends cstats_counterlog {

	// Page ID
	var $PageID = 'add';

	// Project ID
	var $ProjectID = "{B36B93AF-B58F-461B-B767-5F08C12493E9}";

	// Table name
	var $TableName = 'stats_counterlog';

	// Page object name
	var $PageObjName = 'stats_counterlog_add';

	// Page name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		if ($this->UseTokenInUrl) $PageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_MESSAGE], $v);
	}

	function getFailureMessage() {
		return @$_SESSION[EW_SESSION_FAILURE_MESSAGE];
	}

	function setFailureMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_FAILURE_MESSAGE], $v);
	}

	function getSuccessMessage() {
		return @$_SESSION[EW_SESSION_SUCCESS_MESSAGE];
	}

	function setSuccessMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_SUCCESS_MESSAGE], $v);
	}

	function getWarningMessage() {
		return @$_SESSION[EW_SESSION_WARNING_MESSAGE];
	}

	function setWarningMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_WARNING_MESSAGE], $v);
	}

	// Methods to clear message
	function ClearMessage() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
	}

	function ClearFailureMessage() {
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
	}

	function ClearSuccessMessage() {
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
	}

	function ClearWarningMessage() {
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	function ClearMessages() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	// Show message
	function ShowMessage() {

		// $hidden = TRUE;
		$hidden = MS_USE_JAVASCRIPT_MESSAGE;
		$html = "";

		// Message
		$sMessage = $this->getMessage();
		$this->Message_Showing($sMessage, "");
		if ($sMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sMessage;
			$html .= "<div class=\"alert alert-info ewInfo\">" . $sMessage . "</div>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$sWarningMessage = $this->getWarningMessage();
		$this->Message_Showing($sWarningMessage, "warning");
		if ($sWarningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sWarningMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sWarningMessage;
			$html .= "<div class=\"alert alert-warning ewWarning\">" . $sWarningMessage . "</div>";
			$_SESSION[EW_SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$sSuccessMessage = $this->getSuccessMessage();
		$this->Message_Showing($sSuccessMessage, "success");
		if ($sSuccessMessage <> "") { // Message in Session, display

			// if (!$hidden)
			//	 $sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
			// $html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			// Begin of modification Auto Hide Message, by Masino Sinaga, January 24, 2013

			if (@MS_AUTO_HIDE_SUCCESS_MESSAGE) {

				//$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>";
				$html .= "<p class=\"alert alert-success msSuccessMessage\" id=\"ewSuccessMessage\">" . $sSuccessMessage . "</p>";
			} else {
				if (!$hidden)
					$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
				$html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			}

			// End of modification Auto Hide Message, by Masino Sinaga, January 24, 2013
			$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$sErrorMessage = $this->getFailureMessage();
		$this->Message_Showing($sErrorMessage, "failure");
		if ($sErrorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sErrorMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sErrorMessage;
			$html .= "<div class=\"alert alert-danger ewError\">" . $sErrorMessage . "</div>";
			$_SESSION[EW_SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}

		// echo "<div class=\"ewMessageDialog\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div>";
		if (@MS_AUTO_HIDE_SUCCESS_MESSAGE || MS_USE_JAVASCRIPT_MESSAGE==0) {
			echo $html;
		} else {
			if (MS_USE_ALERTIFY_FOR_MESSAGE_DIALOG) {
				if ($html <> "") {
					$html = str_replace("'", "\'", $html);
					echo "<script type='text/javascript'>alertify.alert('".$html."', function (ok) { }).set('title', ewLanguage.Phrase('AlertifyAlert'));</script>";
				}
			} else {
				echo "<div class=\"ewMessageDialog\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div>";
			}
		}
	}
	var $PageHeader;
	var $PageFooter;

	// Show Page Header
	function ShowPageHeader() {
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		if ($sHeader <> "") { // Header exists, display
			echo "<p>" . $sHeader . "</p>";
		}
	}

	// Show Page Footer
	function ShowPageFooter() {
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		if ($sFooter <> "") { // Footer exists, display
			echo "<p>" . $sFooter . "</p>";
		}
	}

	// Validate page request
	function IsPageRequest() {
		global $objForm;
		if ($this->UseTokenInUrl) {
			if ($objForm)
				return ($this->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($this->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}
	var $Token = "";
	var $TokenTimeout = 0;
	var $CheckToken = EW_CHECK_TOKEN;
	var $CheckTokenFn = "ew_CheckToken";
	var $CreateTokenFn = "ew_CreateToken";

	// Valid Post
	function ValidPost() {
		if (!$this->CheckToken || !ew_IsHttpPost())
			return TRUE;
		if (!isset($_POST[EW_TOKEN_NAME]))
			return FALSE;
		$fn = $this->CheckTokenFn;
		if (is_callable($fn))
			return $fn($_POST[EW_TOKEN_NAME], $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	function CreateToken() {
		global $gsToken;
		if ($this->CheckToken) {
			$fn = $this->CreateTokenFn;
			if ($this->Token == "" && is_callable($fn)) // Create token
				$this->Token = $fn();
			$gsToken = $this->Token; // Save to global variable
		}
	}

	//
	// Page class constructor
	//
	function __construct() {
		global $conn, $Language;
		global $UserTable, $UserTableConn;
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = ew_SessionTimeoutTime();

		// Language object
		if (!isset($Language)) $Language = new cLanguage();

		// Parent constuctor
		parent::__construct();

		// Table object (stats_counterlog)
		if (!isset($GLOBALS["stats_counterlog"]) || get_class($GLOBALS["stats_counterlog"]) == "cstats_counterlog") {
			$GLOBALS["stats_counterlog"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["stats_counterlog"];
		}

		// Table object (users)
		if (!isset($GLOBALS['users'])) $GLOBALS['users'] = new cusers();

		// Page ID
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'add', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'stats_counterlog', TRUE);

		// Start timer
		if (!isset($GLOBALS["gTimer"])) $GLOBALS["gTimer"] = new cTimer();

		// Open connection
		if (!isset($conn)) $conn = ew_Connect($this->DBID);

		// User table object (users)
		if (!isset($UserTable)) {
			$UserTable = new cusers();
			$UserTableConn = Conn($UserTable->DBID);
		}
	}

	// 
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsCustomExport, $gsExportFile, $UserProfile, $Language, $Security, $objForm, $UserTableConn;
		if (!isset($_SESSION['table_stats_counterlog_views'])) { 
			$_SESSION['table_stats_counterlog_views'] = 0;
		}
		$_SESSION['table_stats_counterlog_views'] = $_SESSION['table_stats_counterlog_views']+1;

		// User profile
		$UserProfile = new cUserProfile();

		// Security
		$Security = new cAdvancedSecurity();
		if (IsPasswordExpired())
			$this->Page_Terminate(ew_GetUrl("changepwd.php"));
		if (!$Security->IsLoggedIn()) $Security->AutoLogin();
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loading();
		$Security->LoadCurrentUserLevel($this->ProjectID . $this->TableName);
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loaded();
		if (!$Security->CanAdd()) {
			$Security->SaveLastUrl();
			$this->setFailureMessage($Language->Phrase("NoPermission")); // Set no permission
			if ($Security->CanList())
				$this->Page_Terminate(ew_GetUrl("stats_counterloglist.php"));
			else
				$this->Page_Terminate(ew_GetUrl("login.php"));
		}

		// Begin of modification Auto Logout After Idle for the Certain Time, by Masino Sinaga, May 5, 2012
		if (IsLoggedIn() && !IsSysAdmin()) {

			// Begin of modification by Masino Sinaga, May 25, 2012 in order to not autologout after clear another user's session ID whenever back to another page.           
			$UserProfile->LoadProfileFromDatabase(CurrentUserName());

			// End of modification by Masino Sinaga, May 25, 2012 in order to not autologout after clear another user's session ID whenever back to another page.
			// Begin of modification Save Last Users' Visitted Page, by Masino Sinaga, May 25, 2012

			$lastpage = ew_CurrentPage();
			if ($lastpage!='logout.php' && $lastpage!='index.php') {
				$lasturl = ew_CurrentUrl();
				$sFilterUserID = str_replace("%u", ew_AdjustSql(CurrentUserName(), EW_USER_TABLE_DBID), EW_USER_NAME_FILTER);
				ew_Execute("UPDATE ".EW_USER_TABLE." SET Current_URL = '".$lasturl."' WHERE ".$sFilterUserID."", $UserTableConn);
			}

			// End of modification Save Last Users' Visitted Page, by Masino Sinaga, May 25, 2012
			$LastAccessDateTime = strval(@$UserProfile->Profile[EW_USER_PROFILE_LAST_ACCESSED_DATE_TIME]);
			$nDiff = intval(ew_DateDiff($LastAccessDateTime, ew_StdCurrentDateTime(), "s"));
			$nCons = intval(MS_AUTO_LOGOUT_AFTER_IDLE_IN_MINUTES) * 60;
			if ($nDiff > $nCons) {

				//header("Location: logout.php?expired=1");
			}
		}

		// End of modification Auto Logout After Idle for the Certain Time, by Masino Sinaga, May 5, 2012
		// Update last accessed time

		if ($UserProfile->IsValidUser(CurrentUserName(), session_id())) {

			// Do nothing since it's a valid user! SaveProfileToDatabase has been handled from IsValidUser method of UserProfile object.
		} else {

			// Begin of modification How to Overcome "User X already logged in" Issue, by Masino Sinaga, July 22, 2014
			// echo $Language->Phrase("UserProfileCorrupted");

			header("Location: logout.php");

			// End of modification How to Overcome "User X already logged in" Issue, by Masino Sinaga, July 22, 2014
		}
		if (@MS_USE_CONSTANTS_IN_CONFIG_FILE == FALSE) {

			// Call this new function from userfn*.php file
			My_Global_Check();
		}

		// Create form object
		$objForm = new cFormObj();
		$this->CurrentAction = (@$_GET["a"] <> "") ? $_GET["a"] : @$_POST["a_list"]; // Set up current action

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

// Begin of modification Disable/Enable Registration Page, by Masino Sinaga, May 14, 2012
// End of modification Disable/Enable Registration Page, by Masino Sinaga, May 14, 2012
		// Page Load event

		$this->Page_Load();

		// Check token
		if (!$this->ValidPost()) {
			echo $Language->Phrase("InvalidPostRequest");
			$this->Page_Terminate();
			exit();
		}
		if (ALWAYS_COMPARE_ROOT_URL == TRUE) {
			if ($_SESSION['php_stock_Root_URL'] <> Get_Root_URL()) {
				header("Location: " . $_SESSION['php_stock_Root_URL']);
			}
		}

		// Process auto fill
		if (@$_POST["ajax"] == "autofill") {
			$results = $this->GetAutoFill(@$_POST["name"], @$_POST["q"]);
			if ($results) {

				// Clean output buffer
				if (!EW_DEBUG_ENABLED && ob_get_length())
					ob_end_clean();
				echo $results;
				$this->Page_Terminate();
				exit();
			}
		}

		// Create Token
		$this->CreateToken();
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $gsExportFile, $gTmpImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EW_EXPORT, $stats_counterlog;
		if ($this->CustomExport <> "" && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EW_EXPORT)) {
				$sContent = ob_get_contents();
			if ($gsExportFile == "") $gsExportFile = $this->TableVar;
			$class = $EW_EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($stats_counterlog);
				$doc->Text = $sContent;
				if ($this->Export == "email")
					echo $this->ExportEmail($doc->Text);
				else
					$doc->Export();
				ew_DeleteTmpImages(); // Delete temp images
				exit();
			}
		}
		$this->Page_Redirecting($url);

		 // Close connection
		ew_CloseConn();

		// Go to URL if specified
		if ($url <> "") {
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			header("Location: " . $url);
		}
		exit();
	}
	var $FormClassName = "form-horizontal ewForm ewAddForm";
	var $DbMasterFilter = "";
	var $DbDetailFilter = "";
	var $StartRec;
	var $Priv = 0;
	var $OldRecordset;
	var $CopyRecord;

	// 
	// Page main
	//
	function Page_Main() {
		global $objForm, $Language, $gsFormError;

		// Process form if post back
		if (@$_POST["a_add"] <> "") {
			$this->CurrentAction = $_POST["a_add"]; // Get form action
			$this->CopyRecord = $this->LoadOldRecord(); // Load old recordset
			$this->LoadFormValues(); // Load form values

			// End of modification Permission Access for Export To Feature, by Masino Sinaga, May 5, 2012
		} else { // Not post back

			// Load key values from QueryString
			$this->CopyRecord = TRUE;
			if (@$_GET["IP_Address"] != "") {
				$this->IP_Address->setQueryStringValue($_GET["IP_Address"]);
				$this->setKey("IP_Address", $this->IP_Address->CurrentValue); // Set up key
			} else {
				$this->setKey("IP_Address", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if ($this->CopyRecord) {
				$this->CurrentAction = "C"; // Copy record
			} else {
				$this->CurrentAction = "I"; // Display blank record
			}
		}

		// Set up Breadcrumb
		$this->SetupBreadcrumb();

		// Validate form if post back
		if (@$_POST["a_add"] <> "") {
			if (!$this->ValidateForm()) {
				$this->CurrentAction = "I"; // Form error, reset action
				$this->EventCancelled = TRUE; // Event cancelled
				$this->RestoreFormValues(); // Restore form values
				$this->setFailureMessage($gsFormError);
			}
		} else {
			if ($this->CurrentAction == "I") // Load default values for blank record
				$this->LoadDefaultValues();
		}

		// Perform action based on action code
		switch ($this->CurrentAction) {
			case "I": // Blank record, no action required
				break;
			case "C": // Copy an existing record
				if (!$this->LoadRow()) { // Load record based on key
					if ($this->getFailureMessage() == "") $this->setFailureMessage($Language->Phrase("NoRecord")); // No record found
					$this->Page_Terminate("stats_counterloglist.php"); // No matching record, return to list
				}
				break;
			case "A": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->AddRow($this->OldRecordset)) { // Add successful

					// Begin of modification Disable Add/Edit Success Message Box, by Masino Sinaga, August 1, 2012
					if (MS_SHOW_ADD_SUCCESS_MESSAGE==TRUE) {
						if ($this->getSuccessMessage() == "")
							$this->setSuccessMessage($Language->Phrase("AddSuccess")); // Set up success message
					}

					// End of modification Disable Add/Edit Success Message Box, by Masino Sinaga, August 1, 2012
					$sReturnUrl = $this->getReturnUrl();
					if (ew_GetPageName($sReturnUrl) == "stats_counterloglist.php")
						$sReturnUrl = $this->AddMasterUrl($this->GetListUrl()); // List page, return to list page with correct master key if necessary
					elseif (ew_GetPageName($sReturnUrl) == "stats_counterlogview.php")
						$sReturnUrl = $this->GetViewUrl(); // View page, return to view page with keyurl directly
					$this->Page_Terminate($sReturnUrl); // Clean up and return
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->RestoreFormValues(); // Add failed, restore form values
				}
		}

		// Render row based on row type
		$this->RowType = EW_ROWTYPE_ADD; // Render add type

		// Render row
		$this->ResetAttrs();
		$this->RenderRow();
	}

	// Get upload files
	function GetUploadFiles() {
		global $objForm, $Language;

		// Get upload data
	}

	// Load default values
	function LoadDefaultValues() {
		$this->IP_Address->CurrentValue = NULL;
		$this->IP_Address->OldValue = $this->IP_Address->CurrentValue;
		$this->Hostname->CurrentValue = NULL;
		$this->Hostname->OldValue = $this->Hostname->CurrentValue;
		$this->First_Visit->CurrentValue = NULL;
		$this->First_Visit->OldValue = $this->First_Visit->CurrentValue;
		$this->Last_Visit->CurrentValue = NULL;
		$this->Last_Visit->OldValue = $this->Last_Visit->CurrentValue;
		$this->Counter->CurrentValue = 0;
	}

	// Load form values
	function LoadFormValues() {

		// Load from form
		global $objForm;
		if (!$this->IP_Address->FldIsDetailKey) {
			$this->IP_Address->setFormValue($objForm->GetValue("x_IP_Address"));
		}
		if (!$this->Hostname->FldIsDetailKey) {
			$this->Hostname->setFormValue($objForm->GetValue("x_Hostname"));
		}
		if (!$this->First_Visit->FldIsDetailKey) {
			$this->First_Visit->setFormValue($objForm->GetValue("x_First_Visit"));
			$this->First_Visit->CurrentValue = ew_UnFormatDateTime($this->First_Visit->CurrentValue, 9);
		}
		if (!$this->Last_Visit->FldIsDetailKey) {
			$this->Last_Visit->setFormValue($objForm->GetValue("x_Last_Visit"));
			$this->Last_Visit->CurrentValue = ew_UnFormatDateTime($this->Last_Visit->CurrentValue, 9);
		}
		if (!$this->Counter->FldIsDetailKey) {
			$this->Counter->setFormValue($objForm->GetValue("x_Counter"));
		}
	}

	// Restore form values
	function RestoreFormValues() {
		global $objForm;
		$this->LoadOldRecord();
		$this->IP_Address->CurrentValue = $this->IP_Address->FormValue;
		$this->Hostname->CurrentValue = $this->Hostname->FormValue;
		$this->First_Visit->CurrentValue = $this->First_Visit->FormValue;
		$this->First_Visit->CurrentValue = ew_UnFormatDateTime($this->First_Visit->CurrentValue, 9);
		$this->Last_Visit->CurrentValue = $this->Last_Visit->FormValue;
		$this->Last_Visit->CurrentValue = ew_UnFormatDateTime($this->Last_Visit->CurrentValue, 9);
		$this->Counter->CurrentValue = $this->Counter->FormValue;
	}

	// Load row based on key values
	function LoadRow() {
		global $Security, $Language;
		$sFilter = $this->KeyFilter();

		// Call Row Selecting event
		$this->Row_Selecting($sFilter);

		// Load SQL based on filter
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$conn = &$this->Connection();
		$res = FALSE;
		$rs = ew_LoadRecordset($sSql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->LoadRowValues($rs); // Load row values
			$rs->Close();
		}
		return $res;
	}

	// Load row values from recordset
	function LoadRowValues(&$rs) {
		if (!$rs || $rs->EOF) return;

		// Call Row Selected event
		$row = &$rs->fields;
		$this->Row_Selected($row);
		$this->IP_Address->setDbValue($rs->fields('IP_Address'));
		$this->Hostname->setDbValue($rs->fields('Hostname'));
		$this->First_Visit->setDbValue($rs->fields('First_Visit'));
		$this->Last_Visit->setDbValue($rs->fields('Last_Visit'));
		$this->Counter->setDbValue($rs->fields('Counter'));
	}

	// Load DbValue from recordset
	function LoadDbValues(&$rs) {
		if (!$rs || !is_array($rs) && $rs->EOF) return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->IP_Address->DbValue = $row['IP_Address'];
		$this->Hostname->DbValue = $row['Hostname'];
		$this->First_Visit->DbValue = $row['First_Visit'];
		$this->Last_Visit->DbValue = $row['Last_Visit'];
		$this->Counter->DbValue = $row['Counter'];
	}

	// Load old record
	function LoadOldRecord() {

		// Load key values from Session
		$bValidKey = TRUE;
		if (strval($this->getKey("IP_Address")) <> "")
			$this->IP_Address->CurrentValue = $this->getKey("IP_Address"); // IP_Address
		else
			$bValidKey = FALSE;

		// Load old recordset
		if ($bValidKey) {
			$this->CurrentFilter = $this->KeyFilter();
			$sSql = $this->SQL();
			$conn = &$this->Connection();
			$this->OldRecordset = ew_LoadRecordset($sSql, $conn);
			$this->LoadRowValues($this->OldRecordset); // Load row values
		} else {
			$this->OldRecordset = NULL;
		}
		return $bValidKey;
	}

	// Render row values based on field settings
	function RenderRow() {
		global $Security, $Language, $gsLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// IP_Address
		// Hostname
		// First_Visit
		// Last_Visit
		// Counter

		if ($this->RowType == EW_ROWTYPE_VIEW) { // View row

		// IP_Address
		$this->IP_Address->ViewValue = $this->IP_Address->CurrentValue;
		$this->IP_Address->ViewCustomAttributes = "";

		// Hostname
		$this->Hostname->ViewValue = $this->Hostname->CurrentValue;
		$this->Hostname->ViewCustomAttributes = "";

		// First_Visit
		$this->First_Visit->ViewValue = $this->First_Visit->CurrentValue;
		$this->First_Visit->ViewValue = ew_FormatDateTime($this->First_Visit->ViewValue, 9);
		$this->First_Visit->ViewCustomAttributes = "";

		// Last_Visit
		$this->Last_Visit->ViewValue = $this->Last_Visit->CurrentValue;
		$this->Last_Visit->ViewValue = ew_FormatDateTime($this->Last_Visit->ViewValue, 9);
		$this->Last_Visit->ViewCustomAttributes = "";

		// Counter
		$this->Counter->ViewValue = $this->Counter->CurrentValue;
		$this->Counter->ViewCustomAttributes = "";

			// IP_Address
			$this->IP_Address->LinkCustomAttributes = "";
			$this->IP_Address->HrefValue = "";
			$this->IP_Address->TooltipValue = "";

			// Hostname
			$this->Hostname->LinkCustomAttributes = "";
			$this->Hostname->HrefValue = "";
			$this->Hostname->TooltipValue = "";

			// First_Visit
			$this->First_Visit->LinkCustomAttributes = "";
			$this->First_Visit->HrefValue = "";
			$this->First_Visit->TooltipValue = "";

			// Last_Visit
			$this->Last_Visit->LinkCustomAttributes = "";
			$this->Last_Visit->HrefValue = "";
			$this->Last_Visit->TooltipValue = "";

			// Counter
			$this->Counter->LinkCustomAttributes = "";
			$this->Counter->HrefValue = "";
			$this->Counter->TooltipValue = "";
		} elseif ($this->RowType == EW_ROWTYPE_ADD) { // Add row

			// IP_Address
			$this->IP_Address->EditAttrs["class"] = "form-control";
			$this->IP_Address->EditCustomAttributes = "";
			$this->IP_Address->EditValue = ew_HtmlEncode($this->IP_Address->CurrentValue);
			$this->IP_Address->PlaceHolder = ew_RemoveHtml($this->IP_Address->FldCaption());

			// Hostname
			$this->Hostname->EditAttrs["class"] = "form-control";
			$this->Hostname->EditCustomAttributes = "";
			$this->Hostname->EditValue = ew_HtmlEncode($this->Hostname->CurrentValue);
			$this->Hostname->PlaceHolder = ew_RemoveHtml($this->Hostname->FldCaption());

			// First_Visit
			$this->First_Visit->EditAttrs["class"] = "form-control";
			$this->First_Visit->EditCustomAttributes = "";
			$this->First_Visit->EditValue = ew_HtmlEncode(ew_FormatDateTime($this->First_Visit->CurrentValue, 9));
			$this->First_Visit->PlaceHolder = ew_RemoveHtml($this->First_Visit->FldCaption());

			// Last_Visit
			$this->Last_Visit->EditAttrs["class"] = "form-control";
			$this->Last_Visit->EditCustomAttributes = "";
			$this->Last_Visit->EditValue = ew_HtmlEncode(ew_FormatDateTime($this->Last_Visit->CurrentValue, 9));
			$this->Last_Visit->PlaceHolder = ew_RemoveHtml($this->Last_Visit->FldCaption());

			// Counter
			$this->Counter->EditAttrs["class"] = "form-control";
			$this->Counter->EditCustomAttributes = "";
			$this->Counter->EditValue = ew_HtmlEncode($this->Counter->CurrentValue);
			$this->Counter->PlaceHolder = ew_RemoveHtml($this->Counter->FldCaption());

			// Add refer script
			// IP_Address

			$this->IP_Address->LinkCustomAttributes = "";
			$this->IP_Address->HrefValue = "";

			// Hostname
			$this->Hostname->LinkCustomAttributes = "";
			$this->Hostname->HrefValue = "";

			// First_Visit
			$this->First_Visit->LinkCustomAttributes = "";
			$this->First_Visit->HrefValue = "";

			// Last_Visit
			$this->Last_Visit->LinkCustomAttributes = "";
			$this->Last_Visit->HrefValue = "";

			// Counter
			$this->Counter->LinkCustomAttributes = "";
			$this->Counter->HrefValue = "";
		}
		if ($this->RowType == EW_ROWTYPE_ADD ||
			$this->RowType == EW_ROWTYPE_EDIT ||
			$this->RowType == EW_ROWTYPE_SEARCH) { // Add / Edit / Search row
			$this->SetupFieldTitles();
		}

		// Call Row Rendered event
		if ($this->RowType <> EW_ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	function ValidateForm() {
		global $Language, $gsFormError;

		// Initialize form error message
		$gsFormError = "";

		// Check if validation required
		if (!EW_SERVER_VALIDATE)
			return ($gsFormError == "");
		if (!$this->IP_Address->FldIsDetailKey && !is_null($this->IP_Address->FormValue) && $this->IP_Address->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->IP_Address->FldCaption(), $this->IP_Address->ReqErrMsg));
		}
		if (!$this->First_Visit->FldIsDetailKey && !is_null($this->First_Visit->FormValue) && $this->First_Visit->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->First_Visit->FldCaption(), $this->First_Visit->ReqErrMsg));
		}
		if (!ew_CheckDate($this->First_Visit->FormValue)) {
			ew_AddMessage($gsFormError, $this->First_Visit->FldErrMsg());
		}
		if (!$this->Last_Visit->FldIsDetailKey && !is_null($this->Last_Visit->FormValue) && $this->Last_Visit->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->Last_Visit->FldCaption(), $this->Last_Visit->ReqErrMsg));
		}
		if (!ew_CheckDate($this->Last_Visit->FormValue)) {
			ew_AddMessage($gsFormError, $this->Last_Visit->FldErrMsg());
		}
		if (!$this->Counter->FldIsDetailKey && !is_null($this->Counter->FormValue) && $this->Counter->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->Counter->FldCaption(), $this->Counter->ReqErrMsg));
		}
		if (!ew_CheckInteger($this->Counter->FormValue)) {
			ew_AddMessage($gsFormError, $this->Counter->FldErrMsg());
		}

		// Return validate result
		$ValidateForm = ($gsFormError == "");

		// Call Form_CustomValidate event
		$sFormCustomError = "";
		$ValidateForm = $ValidateForm && $this->Form_CustomValidate($sFormCustomError);
		if ($sFormCustomError <> "") {
			ew_AddMessage($gsFormError, $sFormCustomError);
		}
		return $ValidateForm;
	}

	// Add record
	function AddRow($rsold = NULL) {
		global $Language, $Security;
		$conn = &$this->Connection();

		// Load db values from rsold
		if ($rsold) {
			$this->LoadDbValues($rsold);
		}
		$rsnew = array();

		// IP_Address
		$this->IP_Address->SetDbValueDef($rsnew, $this->IP_Address->CurrentValue, "", FALSE);

		// Hostname
		$this->Hostname->SetDbValueDef($rsnew, $this->Hostname->CurrentValue, NULL, FALSE);

		// First_Visit
		$this->First_Visit->SetDbValueDef($rsnew, ew_UnFormatDateTime($this->First_Visit->CurrentValue, 9), ew_CurrentDate(), FALSE);

		// Last_Visit
		$this->Last_Visit->SetDbValueDef($rsnew, ew_UnFormatDateTime($this->Last_Visit->CurrentValue, 9), ew_CurrentDate(), FALSE);

		// Counter
		$this->Counter->SetDbValueDef($rsnew, $this->Counter->CurrentValue, 0, strval($this->Counter->CurrentValue) == "");

		// Call Row Inserting event
		$rs = ($rsold == NULL) ? NULL : $rsold->fields;
		$bInsertRow = $this->Row_Inserting($rs, $rsnew);

		// Check if key value entered
		if ($bInsertRow && $this->ValidateKey && strval($rsnew['IP_Address']) == "") {
			$this->setFailureMessage($Language->Phrase("InvalidKeyValue"));
			$bInsertRow = FALSE;
		}

		// Check for duplicate key
		if ($bInsertRow && $this->ValidateKey) {
			$sFilter = $this->KeyFilter();
			$rsChk = $this->LoadRs($sFilter);
			if ($rsChk && !$rsChk->EOF) {
				$sKeyErrMsg = str_replace("%f", $sFilter, $Language->Phrase("DupKey"));
				$this->setFailureMessage($sKeyErrMsg);
				$rsChk->Close();
				$bInsertRow = FALSE;
			}
		}
		if ($bInsertRow) {
			$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"]; // v11.0.4
			$AddRow = $this->Insert($rsnew);
			$conn->raiseErrorFn = '';
			if ($AddRow) {
			}
		} else {
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->Phrase("InsertCancelled"));
			}
			$AddRow = FALSE;
		}
		if ($AddRow) {

			// Call Row Inserted event
			$rs = ($rsold == NULL) ? NULL : $rsold->fields;
			$this->Row_Inserted($rs, $rsnew);
		}
		return $AddRow;
	}

	// Build export filter for selected records
	function BuildExportSelectedFilter() {
		global $Language;
		$sWrkFilter = "";
		if ($this->Export <> "") {
			$sWrkFilter = $this->GetKeyFilter();
		}
		return $sWrkFilter;
	}

	// Set up Breadcrumb
	function SetupBreadcrumb() {
		global $Breadcrumb, $Language;
		$Breadcrumb = new cBreadcrumb();
		$url = substr(ew_CurrentUrl(), strrpos(ew_CurrentUrl(), "/")+1); // v11.0.4
		$Breadcrumb->Add("list", $this->TableVar, $this->AddMasterUrl("stats_counterloglist.php"), "", $this->TableVar, TRUE);
		$PageId = ($this->CurrentAction == "C") ? "Copy" : "Add";
		$Breadcrumb->Add("add", $PageId, $url); // v11.0.4
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$CustomError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>
<?php ew_Header(FALSE) ?>
<?php

// Create page object
if (!isset($stats_counterlog_add)) $stats_counterlog_add = new cstats_counterlog_add();

// Page init
$stats_counterlog_add->Page_Init();

// Page main
$stats_counterlog_add->Page_Main();

// Begin of modification Displaying Breadcrumb Links in All Pages, by Masino Sinaga, May 4, 2012
getCurrentPageTitle(ew_CurrentPage());

// End of modification Displaying Breadcrumb Links in All Pages, by Masino Sinaga, May 4, 2012
// Global Page Rendering event (in userfn*.php)

Page_Rendering();

// Global auto switch table width style (in userfn*.php), by Masino Sinaga, January 7, 2015
AutoSwitchTableWidthStyle();

// Page Rendering event
$stats_counterlog_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script type="text/javascript">

// Form object
var CurrentPageID = EW_PAGE_ID = "add";
var CurrentForm = fstats_counterlogadd = new ew_Form("fstats_counterlogadd", "add");

// Validate form
fstats_counterlogadd.Validate = function() {
	if (!this.ValidateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.GetForm(), $fobj = $(fobj);
	if ($fobj.find("#a_confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.FormKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = $fobj.find("#a_list").val() == "gridinsert";
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
			elm = this.GetElements("x" + infix + "_IP_Address");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $stats_counterlog->IP_Address->FldCaption(), $stats_counterlog->IP_Address->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_First_Visit");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $stats_counterlog->First_Visit->FldCaption(), $stats_counterlog->First_Visit->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_First_Visit");
			if (elm && !ew_CheckDate(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($stats_counterlog->First_Visit->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_Last_Visit");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $stats_counterlog->Last_Visit->FldCaption(), $stats_counterlog->Last_Visit->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_Last_Visit");
			if (elm && !ew_CheckDate(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($stats_counterlog->Last_Visit->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_Counter");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $stats_counterlog->Counter->FldCaption(), $stats_counterlog->Counter->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_Counter");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($stats_counterlog->Counter->FldErrMsg()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ewForms[val])
			if (!ewForms[val].Validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fstats_counterlogadd.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid. 
 	return true;
 }

// Use JavaScript validation or not
<?php if (EW_CLIENT_VALIDATE) { ?>
fstats_counterlogadd.ValidateRequired = true;
<?php } else { ?>
fstats_counterlogadd.ValidateRequired = false; 
<?php } ?>

// Dynamic selection lists
// Form object for search

</script>
<script type="text/javascript">

// Write your client script here, no need to add script tags.
</script>
<div class="ewToolbar">
<?php if (MS_SHOW_PHPMAKER_BREADCRUMBLINKS) { ?>
<?php $Breadcrumb->Render(); ?>
<?php } ?>
<?php if (MS_SHOW_MASINO_BREADCRUMBLINKS) { ?>
<?php echo MasinoBreadcrumbLinks(); ?>
<?php } ?>
<?php if (MS_LANGUAGE_SELECTOR_VISIBILITY=="belowheader") { ?>
<?php echo $Language->SelectionForm(); ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php $stats_counterlog_add->ShowPageHeader(); ?>
<?php
$stats_counterlog_add->ShowMessage();
?>
<form name="fstats_counterlogadd" id="fstats_counterlogadd" class="<?php echo $stats_counterlog_add->FormClassName ?>" action="<?php echo ew_CurrentPage() ?>" method="post">
<?php if ($stats_counterlog_add->CheckToken) { ?>
<input type="hidden" name="<?php echo EW_TOKEN_NAME ?>" value="<?php echo $stats_counterlog_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="stats_counterlog">
<input type="hidden" name="a_add" id="a_add" value="A">
<div>
<?php if ($stats_counterlog->IP_Address->Visible) { // IP_Address ?>
	<div id="r_IP_Address" class="form-group">
		<label id="elh_stats_counterlog_IP_Address" for="x_IP_Address" class="col-sm-4 control-label ewLabel"><?php echo $stats_counterlog->IP_Address->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="col-sm-8"><div<?php echo $stats_counterlog->IP_Address->CellAttributes() ?>>
<span id="el_stats_counterlog_IP_Address">
<input type="text" data-table="stats_counterlog" data-field="x_IP_Address" name="x_IP_Address" id="x_IP_Address" size="30" maxlength="50" placeholder="<?php echo ew_HtmlEncode($stats_counterlog->IP_Address->getPlaceHolder()) ?>" value="<?php echo $stats_counterlog->IP_Address->EditValue ?>"<?php echo $stats_counterlog->IP_Address->EditAttributes() ?>>
</span>
<?php echo $stats_counterlog->IP_Address->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($stats_counterlog->Hostname->Visible) { // Hostname ?>
	<div id="r_Hostname" class="form-group">
		<label id="elh_stats_counterlog_Hostname" for="x_Hostname" class="col-sm-4 control-label ewLabel"><?php echo $stats_counterlog->Hostname->FldCaption() ?></label>
		<div class="col-sm-8"><div<?php echo $stats_counterlog->Hostname->CellAttributes() ?>>
<span id="el_stats_counterlog_Hostname">
<input type="text" data-table="stats_counterlog" data-field="x_Hostname" name="x_Hostname" id="x_Hostname" size="30" maxlength="50" placeholder="<?php echo ew_HtmlEncode($stats_counterlog->Hostname->getPlaceHolder()) ?>" value="<?php echo $stats_counterlog->Hostname->EditValue ?>"<?php echo $stats_counterlog->Hostname->EditAttributes() ?>>
</span>
<?php echo $stats_counterlog->Hostname->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($stats_counterlog->First_Visit->Visible) { // First_Visit ?>
	<div id="r_First_Visit" class="form-group">
		<label id="elh_stats_counterlog_First_Visit" for="x_First_Visit" class="col-sm-4 control-label ewLabel"><?php echo $stats_counterlog->First_Visit->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="col-sm-8"><div<?php echo $stats_counterlog->First_Visit->CellAttributes() ?>>
<span id="el_stats_counterlog_First_Visit">
<input type="text" data-table="stats_counterlog" data-field="x_First_Visit" data-format="9" name="x_First_Visit" id="x_First_Visit" placeholder="<?php echo ew_HtmlEncode($stats_counterlog->First_Visit->getPlaceHolder()) ?>" value="<?php echo $stats_counterlog->First_Visit->EditValue ?>"<?php echo $stats_counterlog->First_Visit->EditAttributes() ?>>
</span>
<?php echo $stats_counterlog->First_Visit->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($stats_counterlog->Last_Visit->Visible) { // Last_Visit ?>
	<div id="r_Last_Visit" class="form-group">
		<label id="elh_stats_counterlog_Last_Visit" for="x_Last_Visit" class="col-sm-4 control-label ewLabel"><?php echo $stats_counterlog->Last_Visit->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="col-sm-8"><div<?php echo $stats_counterlog->Last_Visit->CellAttributes() ?>>
<span id="el_stats_counterlog_Last_Visit">
<input type="text" data-table="stats_counterlog" data-field="x_Last_Visit" data-format="9" name="x_Last_Visit" id="x_Last_Visit" placeholder="<?php echo ew_HtmlEncode($stats_counterlog->Last_Visit->getPlaceHolder()) ?>" value="<?php echo $stats_counterlog->Last_Visit->EditValue ?>"<?php echo $stats_counterlog->Last_Visit->EditAttributes() ?>>
</span>
<?php echo $stats_counterlog->Last_Visit->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($stats_counterlog->Counter->Visible) { // Counter ?>
	<div id="r_Counter" class="form-group">
		<label id="elh_stats_counterlog_Counter" for="x_Counter" class="col-sm-4 control-label ewLabel"><?php echo $stats_counterlog->Counter->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="col-sm-8"><div<?php echo $stats_counterlog->Counter->CellAttributes() ?>>
<span id="el_stats_counterlog_Counter">
<input type="text" data-table="stats_counterlog" data-field="x_Counter" name="x_Counter" id="x_Counter" size="30" placeholder="<?php echo ew_HtmlEncode($stats_counterlog->Counter->getPlaceHolder()) ?>" value="<?php echo $stats_counterlog->Counter->EditValue ?>"<?php echo $stats_counterlog->Counter->EditAttributes() ?>>
</span>
<?php echo $stats_counterlog->Counter->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div>
<div class="form-group">
	<div class="col-sm-offset-4 col-sm-8">
<button class="btn btn-primary ewButton" name="btnAction" id="btnAction" type="submit"><?php echo $Language->Phrase("AddBtn") ?></button>
<button class="btn btn-danger ewButton" name="btnCancel" id="btnCancel" type="button" data-href="<?php echo $stats_counterlog_add->getReturnUrl() ?>"><?php echo $Language->Phrase("CancelBtn") ?></button>
	</div>
</div>
</form>
<script type="text/javascript">
fstats_counterlogadd.Init();
</script>
<?php
$stats_counterlog_add->ShowPageFooter();
if (EW_DEBUG_ENABLED)
	echo ew_DebugMsg();
?>
<script type="text/javascript">

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (MS_ENTER_MOVING_CURSOR_TO_NEXT_FIELD) { ?>
<script type="text/javascript">
$(document).ready(function(){$("#fstats_counterlogadd:first *:input[type!=hidden]:first").focus(),$("input").keydown(function(i){if(13==i.which){var e=$(this).closest("form").find(":input:visible:enabled"),n=e.index(this);n==e.length-1||(e.eq(e.index(this)+1).focus(),i.preventDefault())}else 113==i.which&&$("#btnAction").click()}),$("select").keydown(function(i){if(13==i.which){var e=$(this).closest("form").find(":input:visible:enabled"),n=e.index(this);n==e.length-1||(e.eq(e.index(this)+1).focus(),i.preventDefault())}else 113==i.which&&$("#btnAction").click()}),$("radio").keydown(function(i){if(13==i.which){var e=$(this).closest("form").find(":input:visible:enabled"),n=e.index(this);n==e.length-1||(e.eq(e.index(this)+1).focus(),i.preventDefault())}else 113==i.which&&$("#btnAction").click()})});
</script>
<?php } ?>
<?php if ($stats_counterlog->Export == "") { ?>
<script type="text/javascript">
$('#btnAction').attr('onclick', 'return alertifyAdd(this)'); function alertifyAdd(obj) { <?php global $Language; ?> if (fstats_counterlogadd.Validate() == true ) { alertify.confirm("<?php echo $Language->Phrase('AlertifyAddConfirm'); ?>", function (e) { if (e) { $(window).unbind('beforeunload'); alertify.success("<?php echo $Language->Phrase('AlertifyAdd'); ?>"); $("#fstats_counterlogadd").submit(); } }).set("title", "<?php echo $Language->Phrase('AlertifyConfirm'); ?>").set("defaultFocus", "cancel").set('oncancel', function(closeEvent){ alertify.error('<?php echo $Language->Phrase('AlertifyCancel'); ?>');}).set('labels', {ok:'<?php echo $Language->Phrase("MyOKMessage"); ?>!', cancel:'<?php echo $Language->Phrase("MyCancelMessage"); ?>'}); } return false; }
</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$stats_counterlog_add->Page_Terminate();
?>
